close all; clear all; clc;

%% Data copied from Infolytica
I_d_ratedspd=[
    0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
5.92119E-15	-1.232568365	-2.455756143	-3.660254133	-4.836895383	-5.976724933	-7.071068	-8.111595968	-9.090389796	-10.00000027	-10.8335047	-11.58455962	-12.24744904	-12.81712798	-13.28926084	-13.6602544	-13.92728518	-14.0883209	-14.142136
1.18424E-14	-2.465136648	-4.911512114	-7.320508011	-9.673790421	-11.95344944	-14.1421355	-16.22319136	-18.18077895	-19.99999983	-21.66700863	-23.16911841	-24.49489721	-25.63425506	-26.57852074	-27.32050784	-27.85456937	-28.17664081	-28.284271
1.65793E-14	-3.697705013	-7.367268261	-10.98076215	-14.5106858	-17.93017438	-21.2132035	-24.33478733	-27.27116874	-30.00000009	-32.50051332	-34.75367803	-36.74234625	-38.45138304	-39.86778158	-40.98076224	-41.78185455	-42.26496171	-42.426407
2.36848E-14	-4.930273296	-9.823024235	-14.64101602	-19.34758084	-23.90689889	-28.284271	-32.44638273	-36.3615579	-39.99999965	-43.33401725	-46.33823682	-48.98979443	-51.26851012	-53.15704149	-54.64101567	-55.70913874	-56.35328162	-56.568542
3.07902E-14	-6.162841661	-12.27878038	-18.30127016	-24.18447622	-29.88362382	-35.355339	-40.5579787	-45.45194769	-49.99999992	-54.16752195	-57.92279644	-61.23724347	-64.0856381	-66.44630233	-68.30127007	-69.63642392	-70.44160252	-70.710678
3.31587E-14	-7.395410029	-14.73453652	-21.96152429	-29.02137161	-35.86034876	-42.426407	-48.66957467	-54.54233749	-60.00000018	-65.00102665	-69.50735605	-73.48469251	-76.90276608	-79.73556317	-81.96152448	-83.56370909	-84.52992342	-84.852814
4.26326E-14	-8.627978309	-17.19029249	-25.62177817	-33.85826665	-41.83707327	-49.4974745	-56.78117006	-63.63272664	-69.99999974	-75.83453058	-81.09191485	-85.73214068	-89.71989316	-93.02482307	-95.62177791	-97.49099328	-98.61824333	-98.994949
4.73695E-14	-9.860546237	-19.64604777	-29.28203102	-38.69516031	-47.8137961	-56.56854	-64.89276318	-72.72311321	-79.99999648	-86.66803144	-92.67647037	-97.97958539	-102.5370166	-106.3140792	-109.2820275	-111.4182735	-112.7065593	-113.13708
5.21065E-14	-11.09311494	-22.1018046	-32.94228616	-43.53205708	-53.7905227	-63.63961	-73.00436142	-81.8135056	-89.99999955	-97.5015392	-104.2610333	-110.2270379	-115.3541482	-119.6033438	-122.9422857	-125.3455627	-126.7948841	-127.27922
5.68434E-14	-12.32568365	-24.55756143	-36.60254133	-48.36895383	-59.76724933	-70.71068	-81.11595968	-90.90389796	-100.0000027	-108.335047	-115.8455962	-122.4744904	-128.1712798	-132.8926084	-136.602544	-139.2728518	-140.883209	-141.42136];

I_q_ratedspd=[
    0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
14.142136	14.0883209	13.92728518	13.6602544	13.28926084	12.81712798	12.24744904	11.58455961	10.8335047	10.00000027	9.090389795	8.111595968	7.071068	5.976724937	4.836895383	3.660254138	2.455756144	1.232568367	1.77636E-15
28.284271	28.17664081	27.85456937	27.32050784	26.57852074	25.63425506	24.49489721	23.16911841	21.66700863	19.99999983	18.18077895	16.22319137	14.1421355	11.95344944	9.673790423	7.320508014	4.911512117	2.465136647	2.36848E-15
42.426407	42.26496171	41.78185454	40.98076224	39.86778158	38.45138304	36.74234625	34.75367803	32.50051332	30.00000009	27.27116874	24.33478733	21.2132035	17.93017438	14.5106858	10.98076214	7.36726826	3.697705011	4.73695E-15
56.568542	56.35328162	55.70913874	54.64101567	53.15704149	51.26851012	48.98979443	46.33823682	43.33401725	39.99999965	36.3615579	32.44638273	28.284271	23.90689889	19.34758084	14.64101603	9.823024236	4.930273294	4.73695E-15
70.710678	70.44160253	69.63642392	68.30127007	66.44630233	64.0856381	61.23724347	57.92279643	54.16752195	49.99999991	45.45194769	40.5579787	35.355339	29.88362382	24.18447622	18.30127016	12.27878038	6.162841663	9.4739E-15
84.852814	84.52992342	83.56370909	81.96152448	79.73556317	76.90276608	73.48469251	69.50735605	65.00102665	60.00000018	54.54233749	48.66957467	42.426407	35.86034876	29.02137161	21.96152429	14.73453652	7.395410027	9.4739E-15
98.994949	98.61824334	97.49099329	95.62177791	93.02482307	89.71989315	85.73214068	81.09191485	75.83453058	69.99999974	63.63272664	56.78117007	49.4974745	41.83707327	33.85826665	25.62177817	17.19029249	8.627978305	9.4739E-15
113.13708	112.7065593	111.4182735	109.2820275	106.3140792	102.5370166	97.97958539	92.67647039	86.66803142	79.99999648	72.72311321	64.89276316	56.56854	47.81379609	38.69516031	29.28203101	19.64604777	9.860546241	1.42109E-14
127.27922	126.7948842	125.3455626	122.9422857	119.6033438	115.3541482	110.2270379	104.2610332	97.50153923	89.99999954	81.81350558	73.00436142	63.63961	53.79052273	43.53205707	32.94228619	22.10180461	11.09311496	9.4739E-15
141.42136	140.883209	139.2728518	136.602544	132.8926084	128.1712798	122.4744904	115.8455961	108.335047	100.0000027	90.90389795	81.11595968	70.71068	59.76724937	48.36895383	36.60254138	24.55756144	12.32568367	1.89478E-14];

lambda_d_ratedspd=[
   0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956	0.217978956
0.22046055	0.218172992	0.215878844	0.213601239	0.21136219	0.209181808	0.207076891	0.205066727	0.203174626	0.201417638	0.19980983	0.198367403	0.197101909	0.196022534	0.195136556	0.194450844	0.193959487	0.193666074	0.193567595
0.225632971	0.221012372	0.216346692	0.21168171	0.207060489	0.202515109	0.198077517	0.193806186	0.189778705	0.186041499	0.182631011	0.179580666	0.176926451	0.174685903	0.172873021	0.171467981	0.170463177	0.169858732	0.169655392
0.22978258	0.223292985	0.216686064	0.209969047	0.203173723	0.196398524	0.189739064	0.183297717	0.177105643	0.171290867	0.166002612	0.161292148	0.157219075	0.15380879	0.151044373	0.148874264	0.147301433	0.146335633	0.146001262
0.230347133	0.22243646	0.214365599	0.206213457	0.197988938	0.189677111	0.181265511	0.172847782	0.164678665	0.156860795	0.14963999	0.143254046	0.137722431	0.133130471	0.129399055	0.1264702	0.124360583	0.123090097	0.122662668
0.228644803	0.219609704	0.210268152	0.200763812	0.1912064	0.181609453	0.171982376	0.162217897	0.152323146	0.142658967	0.133540161	0.12543811	0.118438685	0.11264416	0.107902724	0.104205326	0.101576946	0.100012276	0.099469112
0.225466045	0.215448895	0.205063369	0.194393849	0.183597831	0.172770207	0.161941956	0.151064792	0.139994323	0.128743737	0.117777141	0.107889742	0.099380908	0.092362614	0.086586069	0.082088663	0.078933565	0.077032842	0.076378874
0.221693135	0.2107683	0.199394682	0.187642708	0.175722371	0.163702754	0.15165842	0.139641873	0.127507331	0.115081806	0.102461103	0.090771368	0.08065862	0.072317617	0.065473412	0.060173592	0.056419344	0.054148661	0.05337939
0.218087705	0.206321761	0.193990374	0.181133013	0.168039352	0.154865535	0.141630097	0.128374118	0.11511103	0.101560444	0.087587206	0.074157258	0.062422094	0.052662339	0.044629369	0.038471233	0.034066093	0.031385587	0.030477818
0.214728613	0.202060203	0.188710373	0.174750941	0.160473386	0.146117192	0.131712171	0.117271237	0.102819837	0.08815808	0.072968024	0.057885037	0.044549414	0.033388115	0.024144786	0.017055981	0.011925639	0.008787681	0.007726381
0.211461617	0.197842334	0.183431389	0.168336556	0.152914573	0.137382018	0.121805136	0.106225158	0.090609521	0.074835044	0.058514112	0.041895455	0.026964916	0.014403801	0.003938051	-0.004118791	-0.009939044	-0.013543126	-0.014801501];

lambda_q_ratedspd=[
    -1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05	-1.77681E-05
0.073211614	0.072545625	0.071335147	0.069598671	0.067358143	0.064636043	0.061452614	0.057835695	0.053823729	0.049451404	0.044753029	0.039770177	0.03454201	0.029102923	0.023490534	0.017745939	0.011891287	0.005966339	5.14788E-06
0.145393058	0.143895795	0.141354086	0.137791844	0.133235208	0.127706065	0.121229992	0.113884009	0.105787891	0.097016539	0.08765116	0.077773215	0.067481869	0.056840938	0.045921081	0.034727944	0.023289789	0.011689661	5.06788E-06
0.208566616	0.2072688	0.204477653	0.200095805	0.194076648	0.186496748	0.177432571	0.167023791	0.155292511	0.142421722	0.128669361	0.114145467	0.099000633	0.083378114	0.06734443	0.050900442	0.034120211	0.017118852	-1.51852E-05
0.256677292	0.256192387	0.254153778	0.250509367	0.245064711	0.237574564	0.227773096	0.215595607	0.201367792	0.185235508	0.16763608	0.148967768	0.129368162	0.109088316	0.088133906	0.066579165	0.044589863	0.022334642	-5.63384E-05
0.291362569	0.291718391	0.290471348	0.287563204	0.282916033	0.276315691	0.267525345	0.256032229	0.241430731	0.223991366	0.203875472	0.181836821	0.158341834	0.133847783	0.108304716	0.081890504	0.054883184	0.027498952	-0.000107402
0.318448802	0.319598179	0.319157159	0.316977279	0.312943263	0.306927674	0.298703206	0.28791279	0.273939021	0.256266357	0.235332129	0.21181896	0.185638658	0.157501292	0.127728673	0.096788976	0.065012036	0.032564682	-0.000159964
0.340413134	0.341962506	0.341957519	0.340332588	0.337010032	0.331731686	0.324245493	0.31419109	0.300808681	0.283450797	0.261783483	0.237240846	0.210171652	0.179815353	0.146372003	0.111189849	0.074856479	0.03752891	-0.000217851
0.357767128	0.359494736	0.359760302	0.358476716	0.355602032	0.350960744	0.344227249	0.335039827	0.322875456	0.306470538	0.284699141	0.258987603	0.230938536	0.199911378	0.164043686	0.125090378	0.084343985	0.042355068	-0.000272047
0.371831659	0.373775831	0.374364579	0.373475766	0.370957368	0.366721011	0.360493098	0.351889739	0.340505854	0.325271205	0.304549316	0.278185182	0.248938558	0.217170726	0.180317114	0.138329731	0.093427168	0.046995851	-0.000315497
0.383806692	0.386005612	0.386900842	0.386351565	0.384236488	0.380343614	0.374481053	0.366299425	0.355276648	0.340724761	0.321040459	0.295017232	0.264945497	0.232145977	0.194855239	0.150852146	0.102105162	0.051390556	-0.000342161];

lambda_m_ratedspd=0.217978955878271;  % flux linkage due to PM

%% Algorithm
Id_lambda_d_bool=1; % Id values are in the third quadrant

org_ID=I_d_ratedspd;
org_IQ=I_q_ratedspd;
org_lam_d=lambda_d_ratedspd;
org_lam_q=lambda_q_ratedspd;

% run algorithm to determine look-up table values
[lambda_d_lookup,lambda_q_lookup,Id_lookup,Iq_lookup,lambda_dq_I_dq_data]=Flux2Current_lookup(I_d_ratedspd,I_q_ratedspd,lambda_d_ratedspd,lambda_q_ratedspd,lambda_m_ratedspd,1,1,11,Id_lambda_d_bool);

length=size(I_d_ratedspd,1)*size(I_d_ratedspd,2);
I_d_ratedspd = reshape (I_d_ratedspd',length ,1); % making I_d matrix into a column vector
I_q_ratedspd = reshape (I_q_ratedspd',length ,1); % making I_q matrix into a column vector
lambda_d_ratedspd = reshape (lambda_d_ratedspd', length,1); % making lambda_d matrix into a column vector
lambda_q_ratedspd = reshape (lambda_q_ratedspd', length,1); % making lambda_q matrix into a column vector

lambda_d_ratedspd=lambda_d_ratedspd-lambda_m_ratedspd;

%% Real data

if(Id_lambda_d_bool==1)
    lambda_d=-lambda_d_ratedspd;
    i_d=-I_d_ratedspd;
else
    lambda_d=lambda_d_ratedspd;
    i_d=I_d_ratedspd;    
end

lambda_q=lambda_q_ratedspd;
i_q=I_q_ratedspd;

%% Plots
figure(1)
surf(meshgrid(lambda_d_lookup)',meshgrid(lambda_q_lookup),Iq_lookup)
hold on
scatter3(lambda_d,lambda_q,i_q);
hold off
title('I_q (\lambda_d , \lambda_q)','FontSize',15);
xlabel('\lambda_d (Vs)','FontSize',15);
ylabel('\lambda_q (Vs)','FontSize',15);
zlabel('I_q (A)','FontSize',15);

figure(2)
surf(meshgrid(lambda_d_lookup)',meshgrid(lambda_q_lookup),Id_lookup)
hold on
scatter3(lambda_d,lambda_q,i_d);
hold off
title('I_d (\lambda_d , \lambda_q)','FontSize',15);
xlabel('\lambda_d (Vs)','FontSize',15);
ylabel('\lambda_q (Vs)','FontSize',15);
zlabel('I_d (A)','FontSize',15);

%% Save Look-up data to mat-file

% Save variables to same name as given to mat file
lambda_d = lambda_d_lookup;
lambda_q = lambda_q_lookup;
IQ = Iq_lookup;
ID = Id_lookup;

save('lambda_d','lambda_d');
save('lambda_q','lambda_q');
save('IQ','IQ');
save('ID','ID');