close all; clear all; clc;

%% Data copied from Infolytica
I_d_ratedspd=[
    0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
1.18424E-14	-2.465136648	-4.911512114	-7.320508011	-9.673790421	-11.95344944	-14.1421355	-16.22319136	-18.18077895	-19.99999983	-21.66700863	-23.16911841	-24.49489721	-25.63425506	-26.57852074	-27.32050784	-27.85456937	-28.17664081	-28.284271
2.36848E-14	-4.930273296	-9.823024235	-14.64101602	-19.34758084	-23.90689889	-28.284271	-32.44638273	-36.3615579	-39.99999965	-43.33401725	-46.33823682	-48.98979443	-51.26851012	-53.15704149	-54.64101567	-55.70913874	-56.35328162	-56.568542
3.31587E-14	-7.395410029	-14.73453652	-21.96152429	-29.02137161	-35.86034876	-42.426407	-48.66957467	-54.54233749	-60.00000018	-65.00102665	-69.50735605	-73.48469251	-76.90276608	-79.73556317	-81.96152448	-83.56370909	-84.52992342	-84.852814
4.73695E-14	-9.860546237	-19.64604777	-29.28203102	-38.69516031	-47.8137961	-56.56854	-64.89276318	-72.72311321	-79.99999648	-86.66803144	-92.67647037	-97.97958539	-102.5370166	-106.3140792	-109.2820275	-111.4182735	-112.7065593	-113.13708
5.21065E-14	-12.32568365	-24.55756143	-36.60254133	-48.36895383	-59.76724933	-70.71068	-81.11595968	-90.90389796	-100.0000027	-108.335047	-115.8455962	-122.4744904	-128.1712798	-132.8926084	-136.602544	-139.2728518	-140.883209	-141.42136
6.63173E-14	-14.79082025	-29.46907339	-43.92304911	-58.0427439	-71.72069835	-84.852815	-97.33915047	-109.0846763	-120.0000018	-130.0020548	-139.0147137	-146.9693867	-153.805534	-159.4711282	-163.9230509	-167.1274202	-169.0598488	-169.70563
8.52651E-14	-17.25595679	-34.38058532	-51.24355687	-67.71653395	-83.67414739	-98.99495	-113.5623413	-127.2654546	-140.0000009	-151.6690627	-162.1838313	-171.4642831	-179.4397881	-186.049648	-191.2435578	-194.9819885	-197.2364887	-197.9899
1.04213E-13	-19.72109337	-39.29209728	-58.56406461	-77.39032403	-95.6275964	-113.137085	-129.7855321	-145.4462329	-160	-173.3360705	-185.3529489	-195.9591794	-205.0740423	-212.6281678	-218.5640646	-222.8365569	-225.4131285	-226.27417
1.23161E-13	-22.18622991	-44.20360921	-65.88457237	-87.06411412	-107.5810454	-127.27922	-146.0087229	-163.6270112	-179.9999991	-195.0030784	-208.5220665	-220.4540758	-230.7082964	-239.2066876	-245.8845715	-250.6911253	-253.5897683	-254.55844
1.04213E-13	-24.65136648	-49.11512114	-73.20508011	-96.73790421	-119.5344944	-141.421355	-162.2319136	-181.8077895	-199.9999983	-216.6700863	-231.6911841	-244.9489721	-256.3425506	-265.7852074	-273.2050784	-278.5456937	-281.7664081	-282.84271
1.32635E-13	-27.11650302	-54.0266331	-80.52558785	-106.4116943	-131.4879435	-155.56349	-178.4551044	-199.9885678	-219.9999974	-238.3370941	-254.8603017	-269.4438685	-281.9768047	-292.3637272	-300.5255852	-306.4002621	-309.9430479	-311.12698
1.32635E-13	-29.58163959	-58.93814503	-87.84609561	-116.0854844	-143.4413925	-169.705625	-194.6782952	-218.1693461	-239.9999965	-260.004102	-278.0294193	-293.9387648	-307.6110589	-318.942247	-327.8460921	-334.2548305	-338.1196877	-339.41125
1.51582E-13	-32.04677701	-63.84965871	-95.16660594	-125.7592779	-155.3948457	-183.847765	-210.9014918	-236.3501308	-260.0000027	-281.6711175	-301.1985451	-318.4336698	-333.2453221	-345.5207762	-355.1666086	-362.1094087	-366.2963375	-367.69553
1.7053E-13	-34.51191355	-68.76117064	-102.4871137	-135.433068	-167.3482948	-197.9899	-227.1246826	-254.5309091	-280.0000018	-303.3381254	-324.3676627	-342.9285662	-358.8795762	-372.099296	-382.4871155	-389.9639771	-394.4729773	-395.9798
1.7053E-13	-36.97705013	-73.67268261	-109.8076215	-145.106858	-179.3017438	-212.132035	-243.3478733	-272.7116874	-300.0000009	-325.0051332	-347.5367803	-367.4234625	-384.5138304	-398.6778158	-409.8076224	-417.8185455	-422.6496171	-424.26407];

I_q_ratedspd=[
    0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
28.284271	28.17664081	27.85456937	27.32050784	26.57852074	25.63425506	24.49489721	23.16911841	21.66700863	19.99999983	18.18077895	16.22319137	14.1421355	11.95344944	9.673790423	7.320508014	4.911512117	2.465136647	3.55271E-15
56.568542	56.35328162	55.70913874	54.64101567	53.15704149	51.26851012	48.98979443	46.33823682	43.33401725	39.99999965	36.3615579	32.44638273	28.284271	23.90689889	19.34758084	14.64101603	9.823024236	4.930273294	7.10543E-15
84.852814	84.52992342	83.56370909	81.96152448	79.73556317	76.90276608	73.48469251	69.50735605	65.00102665	60.00000018	54.54233749	48.66957467	42.426407	35.86034876	29.02137161	21.96152429	14.73453652	7.395410027	9.4739E-15
113.13708	112.7065593	111.4182735	109.2820275	106.3140792	102.5370166	97.97958539	92.67647039	86.66803142	79.99999648	72.72311321	64.89276316	56.56854	47.81379609	38.69516031	29.28203101	19.64604777	9.860546241	9.4739E-15
141.42136	140.883209	139.2728518	136.602544	132.8926084	128.1712798	122.4744904	115.8455961	108.335047	100.0000027	90.90389795	81.11595968	70.71068	59.76724937	48.36895383	36.60254138	24.55756144	12.32568367	1.89478E-14
169.7056299	169.0598488	167.1274201	163.9230509	159.4711283	153.8055339	146.9693867	139.0147137	130.0020549	120.0000018	109.0846762	97.3391505	84.85281497	71.72069833	58.04274388	43.92304911	29.46907341	14.79082023	1.89478E-14
197.9899	197.2364886	194.9819885	191.2435578	186.049648	179.4397882	171.4642831	162.1838314	151.6690627	140.0000009	127.2654546	113.5623413	98.99495	83.67414736	67.71653398	51.24355686	34.38058535	17.25595681	1.89478E-14
226.27417	225.4131285	222.8365569	218.5640646	212.6281678	205.0740423	195.9591794	185.3529489	173.3360705	160	145.4462329	129.7855321	113.137085	95.62759639	77.39032403	58.5640646	39.29209729	19.72109337	2.84217E-14
254.55844	253.5897683	250.6911253	245.8845715	239.2066876	230.7082965	220.4540758	208.5220665	195.0030784	179.9999991	163.6270112	146.0087228	127.27922	107.5810454	87.06411412	65.88457235	44.20360923	22.18622995	2.84217E-14
282.84271	281.7664081	278.5456937	273.2050784	265.7852074	256.3425506	244.9489721	231.6911841	216.6700863	199.9999983	181.8077895	162.2319137	141.421355	119.5344944	96.73790423	73.20508014	49.11512117	24.65136647	2.84217E-14
311.12698	309.9430479	306.400262	300.5255852	292.3637273	281.9768047	269.4438685	254.8603017	238.3370942	219.9999973	199.9885678	178.4551044	155.56349	131.4879435	106.4116943	80.52558789	54.02663311	27.11650299	3.78956E-14
339.41125	338.1196877	334.2548304	327.8460921	318.9422471	307.6110589	293.9387648	278.0294193	260.004102	239.9999965	218.1693461	194.6782952	169.705625	143.4413925	116.0854844	87.84609563	58.93814503	29.58163957	3.78956E-14
367.69553	366.2963375	362.1094087	355.1666086	345.5207762	333.2453221	318.4336698	301.1985451	281.6711175	260.0000027	236.3501308	210.9014918	183.847765	155.3948458	125.7592779	95.16660598	63.84965869	32.04677707	3.78956E-14
395.9798	394.4729773	389.9639771	382.4871155	372.099296	358.8795763	342.9285662	324.3676627	303.3381254	280.0000018	254.5309091	227.1246825	197.9899	167.3482948	135.433068	102.4871137	68.76117062	34.51191359	3.78956E-14
424.26407	422.6496171	417.8185454	409.8076224	398.6778158	384.5138304	367.4234625	347.5367803	325.0051332	300.0000009	272.7116874	243.3478733	212.132035	179.3017438	145.106858	109.8076214	73.6726826	36.97705011	1.89478E-14];

lambda_d_ratedspd=[
    0.115045846	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848	0.115045848
0.095024125	0.086713408	0.078261847	0.069538692	0.059725982	0.048393241	0.037279392	0.026772343	0.017005285	0.007888703	-0.000629221	-0.008454097	-0.015256162	-0.019933111	-0.023466997	-0.026926297	-0.029483074	-0.031069758	-0.03162786
0.072961673	0.064682649	0.05418523	0.036713939	0.015160221	-0.006104876	-0.026465278	-0.043548685	-0.053355307	-0.060008238	-0.065752754	-0.07213995	-0.080833821	-0.092810674	-0.104232045	-0.114288977	-0.121965546	-0.124325226	-0.124169718
0.070030583	0.058970457	0.03863248	0.008629961	-0.021899685	-0.047689641	-0.060534806	-0.068784567	-0.0759557	-0.083487794	-0.093756648	-0.110447056	-0.129333844	-0.147760703	-0.161959691	-0.16893984	-0.174111187	-0.181046665	-0.184336328
0.068771795	0.052743983	0.021601495	-0.015099086	-0.048835344	-0.065146128	-0.075488685	-0.084649893	-0.093905225	-0.106251251	-0.126693686	-0.151125564	-0.174287786	-0.186324844	-0.193272688	-0.200528177	-0.210768484	-0.224261657	-0.233856572
0.067047181	0.044626317	0.007014023	-0.033812877	-0.062562821	-0.07665668	-0.088243225	-0.099309966	-0.11203448	-0.132161544	-0.159161729	-0.187217521	-0.203092029	-0.211428881	-0.21969717	-0.231023405	-0.246034136	-0.261981365	-0.26486984
0.0643705	0.035099042	-0.005045407	-0.047055808	-0.07194482	-0.086729826	-0.1001449	-0.113568883	-0.131479252	-0.157652352	-0.188094801	-0.213688303	-0.22530117	-0.234446932	-0.245669164	-0.260444933	-0.279596366	-0.289458233	-0.291339897
0.060580364	0.026094741	-0.014159388	-0.056082029	-0.079973125	-0.096249709	-0.111582233	-0.128281878	-0.152232923	-0.180883707	-0.212298097	-0.233941167	-0.245577772	-0.256542297	-0.271146934	-0.288428247	-0.307667029	-0.314035466	-0.315986002
0.056041984	0.018499033	-0.021173512	-0.063322092	-0.087417912	-0.105416278	-0.122836052	-0.143758597	-0.17185322	-0.200754584	-0.232310831	-0.251951635	-0.264649422	-0.278136316	-0.295606578	-0.314088062	-0.330594228	-0.336781852	-0.339087318
0.051469304	0.012543258	-0.027420169	-0.06984963	-0.094534945	-0.114329026	-0.134100374	-0.159382538	-0.188965131	-0.218017779	-0.249689934	-0.268872362	-0.282988717	-0.299300218	-0.318267885	-0.336648817	-0.351360434	-0.357854403	-0.360357378
0.047602736	0.007701901	-0.033348348	-0.075959144	-0.101394119	-0.122988048	-0.145244797	-0.173845856	-0.203971722	-0.233888864	-0.265725554	-0.285064592	-0.300762725	-0.31938379	-0.338681929	-0.357083724	-0.370916945	-0.377479612	-0.379771987
0.044622943	0.003489042	-0.03904874	-0.081731279	-0.107988019	-0.131307651	-0.156025877	-0.186727703	-0.217810719	-0.248924663	-0.280877247	-0.300626265	-0.317840809	-0.337843812	-0.35744002	-0.376246335	-0.38949681	-0.395795365	-0.397818678
0.042262821	-0.00033626	-0.044520167	-0.087165205	-0.114284192	-0.139192859	-0.166210154	-0.198542973	-0.230904011	-0.263330147	-0.295266211	-0.315510835	-0.333984471	-0.354933548	-0.375109148	-0.394443388	-0.40710008	-0.413034074	-0.414916674
0.040335781	-0.003880195	-0.049742243	-0.092249927	-0.120271364	-0.146652395	-0.175774487	-0.209674279	-0.243429957	-0.277169043	-0.308889054	-0.329632225	-0.349176989	-0.37104554	-0.391952122	-0.411727028	-0.423722382	-0.429433062	-0.431270763
0.038714736	-0.007193168	-0.054684914	-0.096990582	-0.125989548	-0.153780788	-0.184833928	-0.220292133	-0.2554629	-0.290434799	-0.321727916	-0.343008589	-0.363595304	-0.38640662	-0.408090099	-0.428073516	-0.439468528	-0.445132815	-0.446972431
0.037278719	-0.010312125	-0.059310597	-0.101421201	-0.131484197	-0.160668406	-0.193539756	-0.23048937	-0.267051539	-0.30308433	-0.333853927	-0.355773523	-0.377408663	-0.401158108	-0.423573927	-0.443517314	-0.454485302	-0.460238081	-0.462110313];

lambda_q_ratedspd=[
    -3.95945E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06	-3.9435E-06
0.188912603	0.191298829	0.192950774	0.19375237	0.193320287	0.191369422	0.188395892	0.184456565	0.179529921	0.173367331	0.165564161	0.155957164	0.144034621	0.129094709	0.110568828	0.087580581	0.062272785	0.033262948	9.98091E-06
0.236933315	0.237503248	0.237070984	0.235687518	0.233367206	0.230352841	0.226751881	0.222754897	0.218668041	0.214063115	0.208381467	0.200602819	0.188937852	0.172060161	0.153078989	0.131183203	0.098821057	0.056387942	1.56128E-05
0.266304611	0.266286169	0.265419566	0.263014303	0.259197324	0.254613993	0.250412645	0.245975426	0.240874951	0.234519015	0.225363792	0.210484265	0.192120404	0.171558911	0.151016984	0.132603981	0.111189849	0.07593454	8.59795E-06
0.291642659	0.29179935	0.290710648	0.287274797	0.281877514	0.277178958	0.272398075	0.266914365	0.260281603	0.25072189	0.234489304	0.21316537	0.190461025	0.174353376	0.159432195	0.139087223	0.10699574	0.0582038	2.00072E-05
0.314386166	0.315129747	0.313837966	0.309201444	0.303365129	0.298334616	0.292737588	0.286184427	0.27759697	0.263289664	0.241754974	0.216164939	0.197802821	0.183688427	0.166303413	0.139631775	0.097056219	0.039942768	1.48076E-05
0.335053078	0.336638844	0.335197462	0.329213414	0.323193573	0.317746805	0.31138273	0.303752415	0.292656665	0.274638399	0.24937507	0.224000017	0.208263583	0.19249425	0.17035104	0.137256579	0.084100114	0.038725647	1.11499E-05
0.354292614	0.356474612	0.354687906	0.34775487	0.341517623	0.335531964	0.328489311	0.319499462	0.305658369	0.28575184	0.257953844	0.234507664	0.218176424	0.199916031	0.172696564	0.13412705	0.077786577	0.039852813	8.82856E-06
0.372475235	0.374628373	0.372400287	0.365170632	0.358733768	0.352187654	0.344388104	0.33372476	0.317721005	0.296790277	0.267328424	0.244944518	0.227154437	0.205627477	0.174264647	0.131806352	0.078212447	0.040664571	9.34062E-06
0.389677841	0.391317399	0.388806357	0.381629203	0.375013558	0.367923019	0.359285658	0.346765297	0.329256869	0.307450015	0.277274554	0.254937313	0.235307715	0.209964071	0.175788791	0.131324335	0.079801332	0.040956904	4.85464E-06
0.405867533	0.406979211	0.404286476	0.397290652	0.390479547	0.382808756	0.373218228	0.358930007	0.340338591	0.317585493	0.287236234	0.264508502	0.242795862	0.213831022	0.177770285	0.131949359	0.081565078	0.041287146	5.12576E-06
0.421196272	0.421933188	0.419072241	0.412249673	0.405220849	0.396921246	0.386206231	0.370466385	0.350939381	0.327218353	0.296986129	0.273680894	0.249799118	0.217898845	0.180065474	0.13291411	0.083480149	0.042086529	4.2489E-06
0.435897879	0.436366477	0.433319723	0.426577989	0.419288959	0.410330231	0.398428625	0.381477395	0.361032039	0.336382035	0.306421354	0.282464258	0.256509635	0.222198929	0.182468256	0.133936838	0.085662571	0.043318016	4.32345E-06
0.450129242	0.45040075	0.447145562	0.440365296	0.432757479	0.42315896	0.410138191	0.392074758	0.370644039	0.345089625	0.315483345	0.290858943	0.263039057	0.226581364	0.184898927	0.135083923	0.088144141	0.044778122	5.47695E-06
0.463993978	0.46411774	0.460629232	0.453698901	0.445720483	0.435537746	0.421499039	0.402372605	0.379892967	0.35338825	0.324147718	0.298847529	0.269368619	0.230949354	0.187339998	0.136516075	0.090782314	0.046317021	5.65182E-06
0.47756956	0.477572967	0.47382015	0.466657831	0.458284108	0.447558088	0.432585727	0.412449451	0.388893078	0.361408201	0.332428004	0.306415093	0.275472782	0.235257836	0.189810845	0.138281745	0.09339941	0.047865123	5.12121E-06];

lambda_m_ratedspd=0.115045846;  % flux linkage due to PM

%% Algorithm
Id_lambda_d_bool=1; % Id values are in the third quadrant

org_ID=I_d_ratedspd;
org_IQ=I_q_ratedspd;
org_lam_d=lambda_d_ratedspd;
org_lam_q=lambda_q_ratedspd;

% run algorithm to determine look-up table values
[lambda_d_lookup,lambda_q_lookup,Id_lookup,Iq_lookup,lambda_dq_I_dq_data]=Flux2Current_lookup(I_d_ratedspd,I_q_ratedspd,lambda_d_ratedspd,lambda_q_ratedspd,lambda_m_ratedspd,1,2,3,Id_lambda_d_bool);

length=size(I_d_ratedspd,1)*size(I_d_ratedspd,2);
I_d_ratedspd = reshape (I_d_ratedspd',length ,1); % making I_d matrix into a column vector
I_q_ratedspd = reshape (I_q_ratedspd',length ,1); % making I_q matrix into a column vector
lambda_d_ratedspd = reshape (lambda_d_ratedspd', length,1); % making lambda_d matrix into a column vector
lambda_q_ratedspd = reshape (lambda_q_ratedspd', length,1); % making lambda_q matrix into a column vector

lambda_d_ratedspd=lambda_d_ratedspd-lambda_m_ratedspd;

%% Real data

if(Id_lambda_d_bool==1)
    lambda_d=-lambda_d_ratedspd;
    i_d=-I_d_ratedspd;
else
    lambda_d=lambda_d_ratedspd;
    i_d=I_d_ratedspd;    
end

lambda_q=lambda_q_ratedspd;
i_q=I_q_ratedspd;

%% Plots
figure(1)
surf(meshgrid(lambda_d_lookup)',meshgrid(lambda_q_lookup),Iq_lookup)
hold on
scatter3(lambda_d,lambda_q,i_q);
hold off
title('I_q (\Psi_d , \Psi_q)','FontSize',15);
xlabel('\Psi_d (Vs)','FontSize',15);
ylabel('\Psi_q (Vs)','FontSize',15);
zlabel('I_q (A)','FontSize',15);

figure(2)
surf(meshgrid(lambda_d_lookup)',meshgrid(lambda_q_lookup),Id_lookup)
hold on
scatter3(lambda_d,lambda_q,i_d);
hold off
title('I_d (\Psi_d , \Psi_q)','FontSize',15);
xlabel('\Psi_d (Vs)','FontSize',15);
ylabel('\Psi_q (Vs)','FontSize',15);
zlabel('I_d (A)','FontSize',15);

%% Save Look-up data to mat-file

% Save variables to same name as given to mat file
lambda_d = lambda_d_lookup;
lambda_q = lambda_q_lookup;
IQ = Iq_lookup;
ID = Id_lookup;

save('lambda_d','lambda_d');
save('lambda_q','lambda_q');
save('IQ','IQ');
save('ID','ID');