P.Jm = 0.014;
P.Ks = 50/1.1;
P.Ds = 0.5;
P.bl = 0;
P.ue = 10;
P.rw = 21.75*0.0254/2;
P.mv = 1200;
P.ur = 0.01;
P.Jv = P.mv*(P.rw/P.ue)^2;

P.J = P.Jm + P.Jv;

A.Tpe = 1/100;

%% Active damping
Rw.Ts = 1/1000;

Rw.J = P.Jv;
Rw.Gd = 10;

Rw.Ti = 1/P.Ks;
Rw.Tn = Rw.Gd*(1/P.Ks * P.Ds);

Rw.Kp = (Rw.Tn - Rw.Ts/2)/Rw.Ti;
Rw.Ki = Rw.Ts/Rw.Ti;

Rw.Tmax_p = 100;
Rw.Tmax_n = -100;

% Electric drive
D.Vbat = 400; % battery voltage
D.Cbus = 2.5e-3; % bus capacitance
D.Rbus = 0.001; % bus cap ESR

%% speed
D.Wm = 2*pi*1000/60; % radiants per second

% PWM and sampling
D.fpwm = 10000;
D.fs = D.fpwm;
D.Tpwm = 1/D.fpwm;
D.Ts = 1/D.fs;

D.Tcs = 1/(2*pi*100000); % current sensor bandwidth

s = 4;
%% Motor Parameters 
M.Rs = 1.24/2/s;
M.Ld = 0.00414/s^2; 
M.Lq = 0.00414/s^2;
M.Lss = (M.Ld + M.Lq)/50/s^2;
M.P = 4.0;
M.Psir  = 0.05;

%% Initial conditions assuming initial position = 0 and Y connection
M.Id0 = 0;
M.Iq0 = 0;
M.thm0 = 0;
% assuming initial position = 0
M.is0 = [M.Id0 M.Iq0];

%% equivalent small time-constant (used for current regulator tuning)
Ri.Ts = D.Ts;
Ri.Tcalc = 0.5/D.fs;
Ri.Ta = 0.5/D.fpwm;
Ri.Tsh = 0.5/D.fs;
Ri.Tp = Ri.Tcalc + Ri.Ta + Ri.Tsh + D.Tcs;

%% current regulator tuning
Ri.Ra = 0.0;
Ri.R = M.Rs + Ri.Ra;

Ri.Tii = 2/Ri.R*Ri.Tp;
Ri.Tni_D = M.Ld/Ri.R;
Ri.Tni_Q = M.Lq/Ri.R;

Ki = 1/Ri.Tii;
Kp_D = Ri.Tni_D/Ri.Tii;
Kp_Q = Ri.Tni_Q/Ri.Tii;

%% current regulator
Ri.Ra = Ri.Ra;
Ri.Vd0 = M.Rs * M.Iq0;
Ri.Vq0 = M.Rs * M.Id0 + D.Wm*M.P/2*(M.Psir+M.Ld*M.Id0);
Ri.V0 = [Ri.Vd0 Ri.Vq0];
Ri.Tcalc = Ri.Tcalc;
Ri.Ts = Ri.Ts;
Ri.Tn_D = Ri.Tni_D;
Ri.Tn_Q = Ri.Tni_Q;
Ri.Ti = Ri.Tii;
Ri.Kp = [Kp_D Kp_Q];
Ri.Ki = [Ki Ki];