function bode_add_blockset(converter, controller)

%Calculates the loop gain of the system by summing the frequency response
%of the converter and controller, where converter and controller are
%structs produced by the Impulse Response Analysis or AC Sweep Tools.
%
%Example usage: bode_add_blockset(Iconverter, Icontroller)
%
%Correct results will only be obtained if the frequency range and number of data
%points in converter and controller structs are identical.

%Read data
f = converter.F;
response1 = converter.G;
response2 = controller.G;

%Calculate the loop gain
dB1 = 20*log10(abs(response1));
ang1 = angle(response1)*180/pi;
dB2 = 20*log10(abs(response2));
ang2 = angle(response2)*180/pi;

dB_sum = dB1+dB2;
ang_sum = ang1 + ang2;

%Plot Bode plots
figure(2)
subplot(2,1,1)
semilogx(f, dB1, 'm', f, dB2, 'r');
hold on;
h = semilogx(f, dB_sum, 'b');
set(h, 'Linewidth', 2);
grid on;
ylabel('Magnitude (dB)');
legend('Converter', 'Controller', 'Loop gain');

subplot(2,1,2)
semilogx(f, ang1, 'm', f, ang2, 'r');
hold on;
h = semilogx(f, ang_sum, 'b');
set(h, 'Linewidth', 2);
grid on;
xlabel('Frequency (Hz)');
ylabel('Angle (\circ)');