function T = plbode(arg1, arg2, FreqRange, NPoints)

inputType = 'none';

if isstruct(arg1),
  inputType = 'ss';
  if (isfield(arg1,{'a'}))
      A = arg1.a;
      B = arg1.b;
      C = arg1.c;
      D = arg1.d;
  else
      A = arg1.A;
      B = arg1.B;
      C = arg1.C;
      D = arg1.D;
  end
  if size(A,1)~=size(B,1) ...
      || size(C,1)~=size(D,1) ...
      || size(A,2)~=size(C,2) ...
      || size(B,2)~=size(D,2),
    error('Dimensions of state space matrices do not agree');
  end
  if numel(arg2)~=2,
    error('Index list must be a two-element vector');
  end
  inIdx = arg2(1);
  outIdx = arg2(2);
  if inIdx>size(B,2),
    error('Input index exceeds state space dimensions');
  end
  if outIdx>size(C,1),
    error('Output index exceeds state space dimensions');
  end
else
  inputType = 'tf';
  num = arg1;
  den = arg2;
end

lowDecade = log10(FreqRange(1));
highDecade = log10(FreqRange(end));
if nargin<4,
  NPoints = ceil(10*(highDecade-lowDecade));
end
F = logspace(log10(FreqRange(1)),log10(FreqRange(end)),NPoints);
F = union(F, FreqRange(2:end-1));
G = zeros(size(F));

if strcmp(inputType,'tf'),
  nNum = length(num);
  nDen = length(den);
  for idx = 1:length(F),
    s = 2i*pi*F(idx);
    Gn = 0;
    for k = 1:nNum,
      Gn = Gn + num(k)*s^(nNum-k);
    end
    Gd = 0;
    for k = 1:nDen,
      Gd = Gd + den(k)*s^(nDen-k);
    end

    G(idx) = Gn/Gd;
  end
elseif strcmp(inputType,'ss'),
  I = eye(size(A));
  for idx = 1:length(F),
    s = 2i*pi*F(idx);
    G(idx) = C(outIdx,:) * ((s*I - A)\B(:,inIdx)) + D(outIdx,inIdx);
  end
end

figure('Color', [1 1 1]);
hold on
subplot(211);
%hold on
semilogx(F, 20*log10(abs(G))); %plot magnitude
grid on

ylabel('Amplitude (dB)');
subplot(212);
%hold on
semilogx(F, unwrap(angle(G))/pi*180); %plot dB
grid on
ylabel('Phase (\circ)');
xlabel('Frequency (Hz)');

if (nargout),
  T = struct('F',{transpose(F)},'G',{transpose(G)});
end
