function struct_name = type2_controller_bode(file, frange, numpoints)

%Uses the state space extraction tool to find the Bode plot of the
%type 2 based voltage controller. The output is written to a struct in the workspace

%Example usage: Icontroller = type2_controller_bode('Type2_Icontroller', [10 100e3], 101)

open_system(file);

%Print out input and output names to verify the
%correct index position of the input and output
names = plecsedit('get', [file '/Circuit'], 'StateSpaceOrder');
names.Inputs
names.Outputs

%Obtain Bode plot of type2 controller implemented as op-amp circuit
%Extract state space matrices:
sys = plecsedit('get', [file '/Circuit'], 'Topology'); 
n = 1;  %row number of input in names.Inputs
m = 1;  %row number of output in names.Outputs

%Generate the Bode plot and struct
struct_name = plbode(sys, [n m], frange, numpoints);
