'''
Created on Dec 1, 2010

@author: john

Usage: python bode_add.py filename1 filename2
Notes: The files must have exactly the same frequency points
'''

from numpy import *
import matplotlib
matplotlib.use( 'WXAgg' )  #this backend provides antialiasing
from pylab import *
import csv
import sys

if len(sys.argv) != 3:
    print 'Incorrect number of arguments supplied'
else:
    name1 = sys.argv[1]
    if name1.endswith('.csv') == False:
        name1 = name1 + ".csv"  #Create the first file name
        
    name2 = sys.argv[2]
    if name2.endswith('.csv') == False:
        name2 = name2 + ".csv"  

    data1 = list(csv.reader(open(name1, 'rb'), delimiter=',')) #loaded into memory
    data2 = list(csv.reader(open(name2, 'rb'), delimiter=','))
    #data1 = csv.reader(open('Vconverter_bode.csv', 'rb'), delimiter=',')
    #data2 = csv.reader(open('Vcontroller_bode.csv', 'rb'), delimiter=',')

#Create empty numpy arrays for Bode plot data
f = array([])
mag1 = array([]) 
phase1 = array([])
mag2 = array([]) 
phase2 = array([])

#Read data
i = -1
for row in data1: #each row is read into an array object
    if i > -1:   #the first row is the field names
        f = append(f, float(row[0]))  #cast to a float as the item is a string
        mag1 = append(mag1, float(row[1]))
        phase1 = append(phase1, float(row[2]))
    i = i+1

i = -1
for row in data2: #each row is read into an array object
    if i > -1:   #the first row is the field names
        mag2 = append(mag2, float(row[1]))
        phase2 = append(phase2, float(row[2]))
    i = i+1

#Calculate the loop gain
mag_loop = mag1 + mag2
phase_loop = phase1 + phase2   
    
#Plot the results
figure(1)
subplot(211)
title('Frequency Response')
semilogx(f,mag1, f, mag2, f, mag_loop)
legend(('Converter','Controller','Loop'))
ylabel('Magnitude (dB)')
grid(True)  #display major grid
grid(which='minor')  #display minor grid as well

subplot(212)
semilogx(f, phase1, f, phase2, f, phase_loop)
ylabel('Phase (deg)')
xlabel('Frequency (Hz)')
grid(True)
grid(which='minor')
show()


