function bodeadd(converter, controller)

%Calculates the loop gain of the system by summing the frequency response
%of the structs converter and controller.
%The frequency response of the converter is obtained using the impulse
%response analysis or ac sweep tool.
%The frequency response of the controller is obtained using the plbode.m
%function. See bode_type2_controller.m for an example.
%You must ensure the frequency response of both converter and controller
%are over the same range and have the same number of points.
clc

f = converter.F;
response1 = converter.G;
response2 = controller.G;

dB1 = 20*log10(abs(response1));
ang1 = unwrap(angle(response1))*180/pi;
dB2 = 20*log10(abs(response2));
ang2 = unwrap(angle(response2))*180/pi;

dB_sum = dB1+dB2;
ang_sum = ang1 + ang2;

figure(1)
subplot(2,1,1)
semilogx(f, dB1, 'm', f, dB2, 'r');
hold on;
h = semilogx(f, dB_sum, 'b');
set(h, 'Linewidth', 2);
grid on;
ylabel('Magnitude (dB)');
legend('Converter', 'Controller', 'Loop gain');

subplot(2,1,2)
semilogx(f, ang1, 'm', f, ang2, 'r');
hold on;
h = semilogx(f, ang_sum, 'b');
set(h, 'Linewidth', 2);
grid on;
xlabel('Frequency (Hz)');
ylabel('Angle (\circ)');