function bodeadd(str1, str2)

%Calculates the loop gain of the system by summing the magnitude and
%phase response of the converter and controller, which are stored in csv
%files. The csv files should contain the same frequency points.
%Example usage: bodeadd_csv('Iconverter_bode', 'Icontroller_bode')

name1 = [str1 '.csv']; %concatenate csv
name2 = [str2 '.csv'];
data1 = csvread(name1,1,0);
data2 = csvread(name2,1,0);
%data1 = csvread('Icontroller_bode.csv',1,0);
%data2 = csvread('Iconverter_bode.csv',1,0);


%Read converter data
f = data1(:,1);
mag1 = data1(:,2);
phase1 = data1(:,3);

mag2 = data2(:,2);
phase2 = data2(:,3);

%Calculate the loop gain
mag_loop = mag1 + mag2;
phase_loop = phase1 + phase2;


figure(1)
clf
subplot(2,1,1)
semilogx(f, mag1, 'Color', [0.5 0.5 0.5], 'LineWidth',0.5); %light gray
hold on;
semilogx(f, mag2, 'Color', [0.3 0.3 0.3], 'LineWidth',1); %medium gray
semilogx(f, mag_loop, 'k', 'LineWidth',1.5); %black
grid on;
ylabel('Magnitude (dB)');
legend('Converter', 'Controller', 'Loop');

subplot(2,1,2)
semilogx(f, phase1, 'Color', [0.5 0.5 0.5], 'LineWidth',0.5);
hold on;
semilogx(f, phase2, 'Color', [0.3 0.3 0.3], 'LineWidth',1);
semilogx(f, phase_loop, 'k', 'LineWidth',1.5);
hold off
grid on;
xlabel('Frequency (Hz)');
ylabel('Angle (\circ)');