'''
Created on Nov 29, 2011

@author: john schoenberger

Example usage: python bodeadd.py 'converter' 'controller'
Notes: The csv files must contain exactly the same frequency points
'''

from pylab import * #import numpy, scipy, matplotlib
import csv
import sys


class FObject():
    'Reads the f, mag and phase data stored in columns of a csv file'
    
    def __init__(self, filename):
        f, mag, phase = self.load_csv(filename)
        self.f = f
        self.mag = mag
        self.phase = phase
        
        
    def get_data(self):
        return self.f, self.mag, self.phase
    
    
    def load_csv(self, filename):
        if filename.endswith('.csv') == False:
            filename = filename + ".csv"  
        print 'Reading', filename
        data = list(csv.reader(open(filename, 'rb'), delimiter=',')) #loaded into memory
        
        #Create empty lists
        f = []
        mag = []
        phase = []
        
        #Read the rows into numpy arrays
        for i, row in enumerate(data):
            if i > 0:
                if len(row) == 0:
                    break
                f.append(float(row[0]))  #cast to a float as the item is a string
                mag.append(float(row[1]))
                phase.append(float(row[2]))
        
        #Convert list to numpy arrays
        f = array(f)
        mag = array(mag)
        phase = array(phase)
        return (f, mag, phase)
    

if __name__ == '__main__':
    
    data1 = FObject(sys.argv[1])
    data2 = FObject(sys.argv[2])
    f1, mag1, phase1 = data1.get_data()
    f2, mag2, phase2 = data2.get_data()
    
    #Loop gain
    mag_loop = mag1 + mag2
    phase_loop = phase1 + phase2  
    
    #Plot the results
    figure(1)
    subplot(211)
    title('Frequency Response')
    semilogx(f1,mag1, f1, mag2, f1, mag_loop)
    legend(('Converter','Controller','Loop'))
    ylabel('Magnitude (dB)')
    grid(True)  #display major grid
    grid(which='minor')  #display minor grid as well
    
    subplot(212)
    semilogx(f1, phase1, f1, phase2, f1, phase_loop)
    ylabel('Phase (deg)')
    xlabel('Frequency (Hz)')
    grid(True)
    grid(which='minor')
    show()
