proxy = jsonrpc('http://localhost:1080', 'Timeout', 10);

path = pwd;
model_name = 'standalone_from_matlab';
proxy.plecs.load([path '/' model_name '.plecs']);
proxy.plecs.scope([model_name '/Scope'], 'ClearTraces');

simStruct = struct('ModelVars', struct('varL', 50e-6));

% Set value for L1 to be swept
inductorValues = 40:20:220; % in uH

% Allocate memory for cell array
simStructs = cell(size(inductorValues));

% Initialize simStruct as cell array with all values for L1
for ix = 1:length(inductorValues)
   simStructs{ix}.ModelVars.varL = inductorValues(ix) * 1e-6;
   simStructs{ix}.Name = ['L=' mat2str(inductorValues(ix)) 'μH'];
end

results = proxy.plecs.simulate(model_name, simStructs);

plot(results(5).Time,results(5).Values);title(simStructs{5}.Name)