proxy = jsonrpc('http://localhost:1080', 'Timeout', 10);

% Clear all previous traces in scope 'Scope' in the current model

path = pwd;
model_name = 'standalone_from_matlab';
proxy.plecs.load([path '/' model_name '.plecs']);
proxy.plecs.scope([model_name '/Scope'], 'ClearTraces');


% Create simStruct with field 'ModelVars'

simStruct = struct('ModelVars', struct('varL', 50e-6));

% Parametric values to be swept
% Set value for L1 to be swept
inductorValues = 40:20:220; % in uH

% Allocate memory for cell array
simStructs = cell(size(inductorValues));

% Initialize simStruct as cell array with all values for L1
for ix = 1:length(inductorValues)
   simStructs{ix}.ModelVars.varL = inductorValues(ix) * 1e-6;
   simStructs{ix}.Name = ['L=' mat2str(inductorValues(ix)) 'μH'];
end

% Callback function

callback = sprintf([ ... 
'if ischar(result)\n' ...
'   disp(["Possible simulation errors can be asserted here in this message."]);\n' ...
'else\n' ...
'   plecs(''scope'', ''./Scope'', ''HoldTrace'', name);\n' ...
'   result = max(result.Values(1,:));\n' ...
'end\n' ...
]);

results = proxy.plecs.simulate(model_name, simStructs, callback);

plot(inductorValues,results,'-*');
title('Maximum current in A vs. Inductor Values in uH')
